﻿IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NB_SyncItems')
BEGIN	
	CREATE TABLE [dbo].[NB_SyncItems] (
		[Id] int IDENTITY(1,1) NOT NULL,
		[SyncType] int  NOT NULL,
		[ItemId] int  NOT NULL,
		[DestinationId] nvarchar(max)  NOT NULL,
		[Synchronized] datetimeoffset  NOT NULL
	);
	ALTER TABLE [dbo].[NB_SyncItems]
	ADD CONSTRAINT [PK_NB_SyncItems]
		PRIMARY KEY CLUSTERED ([Id] ASC);
END;

IF NOT EXISTS(SELECT * FROM sys.indexes WHERE name='NB_SyncItems_Synchronized' AND object_id = OBJECT_ID('NB_SyncItems'))
BEGIN
	CREATE INDEX NB_SyncItems_Synchronized
	ON dbo.NB_SyncItems (Synchronized)
END;